/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle.views;

import ch.unibas.informatik.jturtle.common.PenState;
import ch.unibas.informatik.jturtle.common.Point;
import ch.unibas.informatik.jturtle.common.Utils;
import ch.unibas.informatik.jturtle.interpreters.Turtle;
import ch.unibas.informatik.jturtle.interpreters.TurtleEventListener;
import ch.unibas.informatik.jturtle.views.ScreenPoint;
import ch.unibas.informatik.jturtle.views.TurtleView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class ImageTurtleView
implements TurtleView,
TurtleEventListener {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 1024;
    private BufferedImage image = null;
    private Graphics2D graphics = null;
    private BufferedImage turtleLogo = null;
    private Turtle turtle = null;
    Point lastTurtleSighting;

    public ImageTurtleView(Turtle turtle) {
        this.turtle = turtle;
        this.lastTurtleSighting = turtle.getPosition();
        this.initialize();
        URL url = this.getClass().getResource("/turtle.png");
        try {
            this.turtleLogo = ImageIO.read(url);
        }
        catch (Exception e) {
            System.err.println("could not read turtle logo");
            System.err.println(e.getMessage());
        }
    }

    @Override
    public BufferedImage getImage() {
        this.image.flush();
        return this.image;
    }

    @Override
    public void positionChanged() {
        ScreenPoint startPosInWindow = this.turtleToImageCoordinate(this.lastTurtleSighting);
        ScreenPoint endPosInWindow = this.turtleToImageCoordinate(this.turtle.getPosition());
        if (this.turtle.getPenState() == PenState.PEN_DOWN) {
            this.graphics.setColor(this.turtle.getPenColor());
            this.graphics.setStroke(new BasicStroke(this.turtle.getPenSize()));
            this.graphics.drawLine(startPosInWindow.getX(), startPosInWindow.getY(), endPosInWindow.getX(), endPosInWindow.getY());
        }
        this.lastTurtleSighting = this.turtle.getPosition();
    }

    @Override
    public void headingChanged() {
    }

    @Override
    public void penStateChanged() {
    }

    @Override
    public void penColorChanged() {
    }

    @Override
    public void penSizeChanged() {
    }

    @Override
    public void clear() {
        this.graphics.setColor(Color.WHITE);
        this.graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.graphics.setColor(this.turtle.getPenColor());
    }

    @Override
    public void fill() {
        ScreenPoint screenPoint = this.turtleToImageCoordinate(this.turtle.getPosition());
        int colorToFill = this.image.getRGB(screenPoint.x, screenPoint.y);
        if (colorToFill == this.turtle.getPenColor().getRGB()) {
            return;
        }
        LinkedList<ScreenPoint> q = new LinkedList<ScreenPoint>();
        q.addLast(screenPoint);
        while (!q.isEmpty()) {
            ScreenPoint position = (ScreenPoint)q.removeFirst();
            if (position.x < 0 || position.x >= 1024 || position.y < 0 || position.y >= 1024 || this.image.getRGB(position.x, position.y) != colorToFill) continue;
            this.image.setRGB(position.x, position.y, this.turtle.getPenColor().getRGB());
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    q.addLast(new ScreenPoint(position.x + i, position.y + j));
                }
            }
        }
    }

    @Override
    public void writeText(String text, int fontSize) {
        ScreenPoint sp = this.turtleToImageCoordinate(this.turtle.getPosition());
        this.graphics.setFont(new Font("TimesRoman", 0, fontSize));
        this.graphics.setColor(this.turtle.getPenColor());
        this.graphics.drawString(text, sp.getX(), sp.getY());
    }

    public void drawTurtle() {
        ScreenPoint sp = this.turtleToImageCoordinate(this.turtle.getPosition());
        if (this.turtleLogo != null) {
            int xPos = sp.getX() - this.turtleLogo.getWidth() / 2;
            int yPos = sp.getY() - this.turtleLogo.getHeight() / 2;
            AffineTransform tx = AffineTransform.getRotateInstance(Utils.degreeToRad(this.turtle.getHeading()), this.turtleLogo.getWidth() / 2, this.turtleLogo.getHeight() / 2);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            this.graphics.drawImage((Image)op.filter(this.turtleLogo, null), xPos, yPos, null);
        }
    }

    private ScreenPoint pointInCanvas(ScreenPoint point) {
        int x = Math.max(0, Math.min(1024, point.getX()));
        int y = Math.max(0, Math.min(1024, point.getY()));
        return new ScreenPoint(x, y);
    }

    private void initialize() {
        this.image = new BufferedImage(1024, 1024, 2);
        this.graphics = this.image.createGraphics();
        this.graphics.setStroke(new BasicStroke(this.turtle.getPenSize()));
        this.clear();
    }

    private ScreenPoint turtleToImageCoordinate(Point point) {
        double scaleFactorX = 5.0;
        double scaleFactorY = -5.0;
        return new ScreenPoint((int)Math.round(point.getX() * scaleFactorX + 512.0), (int)Math.round(point.getY() * scaleFactorY + 512.0));
    }
}

