/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle.interpreters;

import ch.unibas.informatik.jturtle.common.PenState;
import ch.unibas.informatik.jturtle.common.Point;
import ch.unibas.informatik.jturtle.common.Utils;
import ch.unibas.informatik.jturtle.common.Vector;
import ch.unibas.informatik.jturtle.interpreters.Turtle;
import ch.unibas.informatik.jturtle.interpreters.TurtleEventListener;
import java.awt.Color;
import java.util.LinkedList;
import java.util.function.Consumer;

public class DefaultTurtle
implements Turtle {
    private Point currentPosition = new Point(0.0, 0.0);
    private double angleInDegree = 0.0;
    private Color penColor = null;
    private int penSize = 0;
    private PenState penState = PenState.PEN_DOWN;
    private LinkedList<TurtleEventListener> listeners = new LinkedList();

    public DefaultTurtle() {
        this.reset();
    }

    @Override
    public void addListener(TurtleEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Point getPosition() {
        return this.currentPosition;
    }

    @Override
    public Color getPenColor() {
        return this.penColor;
    }

    @Override
    public PenState getPenState() {
        return this.penState;
    }

    @Override
    public double getHeading() {
        return this.angleInDegree;
    }

    @Override
    public int getPenSize() {
        return this.penSize;
    }

    @Override
    public void reset() {
        this.penColor = Color.BLACK;
        this.penSize = 2;
        this.penState = PenState.PEN_DOWN;
        this.publish(listener -> listener.penColorChanged());
        this.publish(listener -> listener.penSizeChanged());
        this.publish(listener -> listener.penStateChanged());
        this.home();
    }

    @Override
    public void home() {
        PenState backupState = this.penState;
        this.setPenState(PenState.PEN_UP);
        this.currentPosition = new Point(0.0, 0.0);
        this.angleInDegree = 0.0;
        this.publish(listener -> listener.positionChanged());
        this.publish(listener -> listener.headingChanged());
        this.setPenState(backupState);
    }

    @Override
    public void move(double distance) {
        double degreeInRad = Utils.degreeToRad(this.angleInDegree);
        int sign = distance >= 0.0 ? 1 : -1;
        Vector v = new Vector(Math.sin(degreeInRad), Math.cos(degreeInRad)).times(sign);
        for (double distanceWalked = 0.0; distanceWalked < Math.abs(distance); distanceWalked += 1.0) {
            double stepLength = Math.min(Math.abs(distance) - distanceWalked, 1.0);
            this.currentPosition = this.currentPosition.plus(v.times(stepLength));
        }
        this.publish(listener -> listener.positionChanged());
    }

    @Override
    public void goTo(Point point) {
        this.currentPosition = point;
        this.publish(listener -> listener.positionChanged());
    }

    @Override
    public void setPenColor(Color color) {
        this.penColor = color;
        this.publish(listener -> listener.penColorChanged());
    }

    @Override
    public void setPenState(PenState penState) {
        this.penState = penState;
        this.publish(listener -> listener.penStateChanged());
    }

    @Override
    public void setPenSize(int size) {
        this.penSize = size;
        this.publish(listener -> listener.penSizeChanged());
    }

    @Override
    public void setPosition(Point pos) {
        this.currentPosition = pos;
    }

    @Override
    public void setHeading(double angleInDegree) {
        this.angleInDegree = angleInDegree;
        this.publish(listener -> listener.headingChanged());
    }

    @Override
    public void turn(double angleInDegree) {
        this.angleInDegree = Utils.normalizeAngle(this.angleInDegree + angleInDegree);
        this.publish(listener -> listener.penSizeChanged());
    }

    private void publish(Consumer<TurtleEventListener> listenerCall) {
        for (TurtleEventListener listener : this.listeners) {
            listenerCall.accept(listener);
        }
    }
}

