/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle.app;

import ch.unibas.informatik.jturtle.TurtleCommands;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class Example {
    static Random random = new Random(18L);

    static void randomTree(double length, double minLength, int thickness, int minThickness, double minAngle, double maxAngle, double minShrink, double maxShrink) {
        if (length < minLength || thickness < minThickness) {
            return;
        }
        double angle1 = minAngle + random.nextDouble() * (maxAngle - minAngle);
        double angle2 = minAngle + random.nextDouble() * (maxAngle - minAngle);
        double shrink1 = minShrink + random.nextDouble() * (maxShrink - minShrink);
        double shrink2 = minShrink + random.nextDouble() * (maxShrink - minShrink);
        TurtleCommands.penSize(thickness);
        TurtleCommands.forward(length);
        TurtleCommands.turnRight(angle1);
        Example.randomTree(length * shrink1, minLength, (int)((double)thickness * shrink1), minThickness, minAngle, maxAngle, minShrink, maxShrink);
        TurtleCommands.turnLeft(angle1 + angle2);
        Example.randomTree(length * shrink2, minLength, (int)((double)thickness * shrink2), minThickness, minAngle, maxAngle, minShrink, maxShrink);
        TurtleCommands.turnRight(angle2);
        TurtleCommands.penSize(thickness);
        TurtleCommands.backward(length);
    }

    static void tree(int levels, double trunkLen, double angle, double shrinkFactor) {
        if (levels > 0) {
            TurtleCommands.forward(trunkLen);
            TurtleCommands.turnRight(angle);
            Example.tree(levels - 1, trunkLen * shrinkFactor, angle, shrinkFactor);
            TurtleCommands.turnLeft(angle * 2.0);
            Example.tree(levels - 1, trunkLen * shrinkFactor, angle, shrinkFactor);
            TurtleCommands.turnRight(angle);
            TurtleCommands.penUp();
            TurtleCommands.backward(trunkLen);
            TurtleCommands.penDown();
        }
    }

    public static void main(String[] args) throws IOException {
        TurtleCommands.clear();
        TurtleCommands.home();
        Example.randomTree(20.0, 2.0, 12, 1, 10.0, 30.0, 0.75, 1.0);
        ImageIO.write((RenderedImage)TurtleCommands.drawing(), "png", new File("image.png"));
    }
}

