/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle;

import ch.unibas.informatik.jturtle.commands.ClearCommand;
import ch.unibas.informatik.jturtle.commands.FillCommand;
import ch.unibas.informatik.jturtle.commands.MoveCommand;
import ch.unibas.informatik.jturtle.commands.PenColorCommand;
import ch.unibas.informatik.jturtle.commands.PenSizeCommand;
import ch.unibas.informatik.jturtle.commands.PenStateCommand;
import ch.unibas.informatik.jturtle.commands.SetHeadingCommand;
import ch.unibas.informatik.jturtle.commands.SetPositionCommand;
import ch.unibas.informatik.jturtle.commands.TurnCommand;
import ch.unibas.informatik.jturtle.commands.TurtleCommand;
import ch.unibas.informatik.jturtle.commands.WriteTextCommand;
import ch.unibas.informatik.jturtle.graphics.ImageTurtleInterpreter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class Turtle {
    public static final int CANVAS_SIZE_X = 200;
    public static final int CANVAS_SIZE_Y = 200;
    private LinkedList<TurtleCommand> commands = new LinkedList();

    public void clear() {
        this.commands.addLast(new ClearCommand());
    }

    public void penDown() {
        this.commands.addLast(new PenStateCommand(true));
    }

    public void penUp() {
        this.commands.addLast(new PenStateCommand(false));
    }

    public void forward(double distance) {
        this.commands.addLast(new MoveCommand(distance));
    }

    public void backward(double distance) {
        this.commands.addLast(new MoveCommand(-distance));
    }

    public void home() {
        this.commands.addLast(new SetPositionCommand(0, 0));
        this.commands.addLast(new SetHeadingCommand(0));
    }

    public void turnRight(double angle) {
        this.commands.addLast(new TurnCommand(angle));
    }

    public void turnLeft(double angle) {
        this.commands.addLast(new TurnCommand(-angle));
    }

    public void penColor(Color color) {
        this.commands.addLast(new PenColorCommand(color));
    }

    public void penSize(int size) {
        this.commands.addLast(new PenSizeCommand(size));
    }

    public void writeText(String text) {
        this.commands.addLast(new WriteTextCommand(text));
    }

    public void fill() {
        this.commands.addLast(new FillCommand());
    }

    public BufferedImage toImage() {
        ImageTurtleInterpreter interpreter = new ImageTurtleInterpreter();
        return interpreter.runTurtle(this, this.commands);
    }
}

