/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle.graphics;

import ch.unibas.informatik.jturtle.Turtle;
import ch.unibas.informatik.jturtle.commands.ClearCommand;
import ch.unibas.informatik.jturtle.commands.MoveCommand;
import ch.unibas.informatik.jturtle.commands.PenColorCommand;
import ch.unibas.informatik.jturtle.commands.PenSizeCommand;
import ch.unibas.informatik.jturtle.commands.PenStateCommand;
import ch.unibas.informatik.jturtle.commands.SetHeadingCommand;
import ch.unibas.informatik.jturtle.commands.SetPositionCommand;
import ch.unibas.informatik.jturtle.commands.TurnCommand;
import ch.unibas.informatik.jturtle.commands.TurtleCommand;
import ch.unibas.informatik.jturtle.common.Point;
import ch.unibas.informatik.jturtle.graphics.ScreenPoint;
import ch.unibas.informatik.jturtle.graphics.TurtleInterpreter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ImageTurtleInterpreter
implements TurtleInterpreter {
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 1024;
    private boolean isPenDown = false;
    private Point currentPosition = new Point(0.0, 0.0);
    private double angleDegree = 0.0;
    private BufferedImage image = null;
    private Graphics2D graphics = null;

    public ImageTurtleInterpreter() {
        this.initialize();
    }

    public BufferedImage runTurtle(Turtle turtle, List<TurtleCommand> commands) {
        for (TurtleCommand command : commands) {
            command.interpret(this);
        }
        return this.image;
    }

    @Override
    public void interpretClear(ClearCommand clearDommand) {
        this.initialize();
    }

    @Override
    public void interpretMove(MoveCommand moveCommand) {
        double newX = this.currentPosition.getX() + Math.sin(ImageTurtleInterpreter.degreeToRad(this.angleDegree)) * moveCommand.getDistance();
        double newY = this.currentPosition.getY() - Math.cos(ImageTurtleInterpreter.degreeToRad(this.angleDegree)) * moveCommand.getDistance();
        Point newPosition = new Point(newX, newY);
        ScreenPoint startPosInWindow = this.turtleToImageCoordinate(this.currentPosition);
        ScreenPoint endPosInWindow = this.turtleToImageCoordinate(newPosition);
        if (this.isPenDown) {
            this.graphics.drawLine(startPosInWindow.getX(), startPosInWindow.getY(), endPosInWindow.getX(), endPosInWindow.getY());
        }
        this.currentPosition = newPosition;
    }

    @Override
    public void interpretPenColor(PenColorCommand pencolor) {
        this.graphics.setColor(pencolor.getPenColor());
    }

    @Override
    public void interpretPenState(PenStateCommand penStateCommand) {
        this.isPenDown = penStateCommand.isPenDown();
    }

    @Override
    public void interpretPenSize(PenSizeCommand penSizeCommand) {
        this.graphics.setStroke(new BasicStroke(penSizeCommand.getSize()));
    }

    @Override
    public void interpretSetPosition(SetPositionCommand pos) {
        this.currentPosition = pos.getPosition();
    }

    @Override
    public void interpretSetHeading(SetHeadingCommand heading) {
        this.angleDegree = heading.getAngle();
    }

    @Override
    public void interpretTurn(TurnCommand turnCommand) {
        this.angleDegree = this.normalizeAngle(this.angleDegree + turnCommand.getAngle());
    }

    private static double degreeToRad(double degree) {
        return degree / 360.0 * Math.PI * 2.0;
    }

    private ScreenPoint pointInCanvas(ScreenPoint point) {
        int x = Math.max(0, Math.min(1024, point.getX()));
        int y = Math.max(0, Math.min(1024, point.getY()));
        return new ScreenPoint(x, y);
    }

    private void initialize() {
        this.image = new BufferedImage(1024, 1024, 2);
        this.graphics = this.image.createGraphics();
        this.graphics.setStroke(new BasicStroke(1.0f));
        this.graphics.setColor(Color.BLACK);
        this.currentPosition = new Point(0.0, 0.0);
        this.angleDegree = 0.0;
    }

    private ScreenPoint turtleToImageCoordinate(Point point) {
        double scaleFactorX = 5.0;
        double scaleFactorY = 5.0;
        return new ScreenPoint((int)Math.round(point.getX() * scaleFactorX + 512.0), (int)Math.round(point.getY() * scaleFactorY + 512.0));
    }

    private double normalizeAngle(double angle) {
        double normalizedAngle = (angle % 360.0 + 360.0) % 360.0;
        if (normalizedAngle > 180.0) {
            return normalizedAngle;
        }
        return normalizedAngle - 360.0;
    }
}

