/*
 * Copyright 2019 University of Basel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.unibas.informatik.jturtle.commands;

import ch.unibas.informatik.jturtle.graphics.TurtleInterpreter;

public class PenStateCommand implements TurtleCommand {
  boolean penDown = false;

  public PenStateCommand(boolean penDown) {
    this.penDown = penDown;
  }

  public boolean isPenDown() { return this.penDown; }
  public boolean isPenUp() { return this.isPenUp(); }

  @Override
  public void interpret(TurtleInterpreter interpreter) {
    interpreter.interpretPenState(this);
  }



}
