/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.jturtle.graphics;

import ch.unibas.informatik.jturtle.Turtle;
import ch.unibas.informatik.jturtle.commands.Move;
import ch.unibas.informatik.jturtle.commands.PenColor;
import ch.unibas.informatik.jturtle.commands.PenDown;
import ch.unibas.informatik.jturtle.commands.PenSize;
import ch.unibas.informatik.jturtle.commands.PenUp;
import ch.unibas.informatik.jturtle.commands.Turn;
import ch.unibas.informatik.jturtle.commands.TurtleCommand;
import ch.unibas.informatik.jturtle.common.Point;
import ch.unibas.informatik.jturtle.graphics.TurtleInterpreter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ImageTurtleInterpreter
implements TurtleInterpreter {
    private static final int WIDTH = 512;
    private static final int HEIGHT = 512;
    private boolean isPenDown = false;
    private Point currentPosition = new Point(256, 256);
    private Color penColor = Color.BLACK;
    private double angleRad = 0.0;
    private int penSize = 1;
    private BufferedImage image = new BufferedImage(512, 512, 2);
    private Graphics2D graphics = this.image.createGraphics();

    public BufferedImage runTurtle(Turtle turtle, List<TurtleCommand> commands) {
        for (TurtleCommand command : commands) {
            command.interpret(this);
        }
        return this.image;
    }

    @Override
    public void interpretMove(Move move) {
        long newX = Math.round((double)this.currentPosition.getX() + Math.sin(this.angleRad) * (double)move.getDistance());
        long newY = Math.round((double)this.currentPosition.getY() - Math.cos(this.angleRad) * (double)move.getDistance());
        Point newPosition = new Point((int)newX, (int)newY);
        Point newDrawingEndPoint = this.pointInCanvas(newPosition);
        this.graphics.setColor(this.penColor);
        this.graphics.setStroke(new BasicStroke(this.penSize));
        if (this.isPenDown) {
            this.graphics.drawLine(this.currentPosition.getX(), this.currentPosition.getY(), newDrawingEndPoint.getX(), newDrawingEndPoint.getY());
        }
        this.currentPosition = newPosition;
    }

    @Override
    public void interpretPenColor(PenColor pencolor) {
        this.penColor = pencolor.getPenColor();
    }

    @Override
    public void interpretPenDown(PenDown penDown) {
        this.isPenDown = true;
    }

    @Override
    public void interpretPenUp(PenUp penUp) {
        this.isPenDown = false;
    }

    @Override
    public void interpretPenSize(PenSize penSize) {
        this.penSize = penSize.getSize();
    }

    @Override
    public void interpretTurn(Turn turn) {
        this.angleRad = (this.angleRad + ImageTurtleInterpreter.degreeToRad(turn.getAngle())) % (Math.PI * 2);
    }

    private static double degreeToRad(double degree) {
        return degree / 360.0 * Math.PI * 2.0;
    }

    private Point pointInCanvas(Point point) {
        int x = Math.max(0, Math.min(512, point.getX()));
        int y = Math.max(0, Math.min(512, point.getY()));
        return new Point(x, y);
    }
}

