package ch.unibas.informatik.jturtle;

import ch.unibas.informatik.jturtle.commands.*;
import ch.unibas.informatik.jturtle.graphics.ImageTurtleInterpreter;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.awt.*;

public class Turtle {
  private LinkedList<TurtleCommand> commands = null;

  public Turtle() {
    this.commands = new LinkedList<>();
  }

  public void penDown() {
    this.commands.addLast(new PenDown());
  }

  public void penUp() { this.commands.addLast(new PenUp());}

  public void move(long distance) {
    this.commands.addLast(new Move(distance));
  }

  public void turn(double angle) {
    this.commands.addLast(new Turn(angle));
  }

  public void penColor(Color color) {this.commands.addLast(new PenColor(color));}

  public void penSize(int size) {this.commands.addLast(new PenSize(size)); }

  public BufferedImage toImage() {
    ImageTurtleInterpreter interpreter = new ImageTurtleInterpreter();
    return interpreter.runTurtle(this, commands);
  }


}
